import importlib.util, sys, pathlib

mod_path = pathlib.Path("orig/simulation/compute_tension.py")
spec = importlib.util.spec_from_file_location("fphs_compute_tension", mod_path)
ct_mod = importlib.util.module_from_spec(spec)
sys.modules["fphs_compute_tension"] = ct_mod  # <<< register before exec
spec.loader.exec_module(ct_mod)

# pick a known-good point
L, gauge, b, k, n0 = 8, "SU2", 2.5, 0.1, 0
kernel_path = f"data/kernels/kernel_{gauge}_L{L}.npy"
flip_path   = f"data/results/vol4_loop_fluctuation_sim/L{L}/flip_counts_L{L}.npy"

sigma, sigma_err, meta = ct_mod.compute_tension_with_err(
    b=b, k_exp=k, n0=n0, L=L, gauge=gauge,
    volumes=[6,8,10,12,16,20], fit_range=[1,3],
    kernel_path=kernel_path, flip_counts_path=flip_path,
    bootstrap_reps=400, bootstrap_block=0, bootstrap_seed=1337,
    kernel_hash_guard=True,
)

print("OK:", sigma, sigma_err)
print("meta keys:", sorted(meta.keys()))
